package com.ejie.ab04b.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.StringTokenizer;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.ConstantesDocumentos;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.Promotor;
import com.ejie.ab04b.model.Proyectista;
import com.ejie.ab04b.model.VfichaApertura;
import com.ejie.ab04b.util.CaracteresRarosUtil;

/**
 * GeneracionPDFCartaAperturaImpl generated by UDA, 11-Jan-2017 12:23:08.
 * 
 * @author UDA
 */

@Service(value = "generacionPDFCartaAperturaImpl")
public class GeneracionPDFCartaAperturaImpl
		implements GeneracionPDFCartaAperturaService {

	@Autowired
	private PromotorService promotorService;
	@Autowired
	private ProyectistaService proyectistaService;
	@Autowired
	private CoordinadorObraService coordinadorObraService;
	@Autowired
	private VfichaAperturaService vfichaAperturaService;

	/**
	 * Devuelve un InputStream con el documento pdf.
	 * 
	 * listadoFolderNumber String[] Inputstream
	 * 
	 * @param listadoFolderNumber
	 *            the listado folder number
	 * @return the pdf
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public InputStream getPDF(String[] listadoFolderNumber)
			throws AB04BException {
		try {
			String xslFichero = "";
			xslFichero = ConstantesDocumentos.CARTA_APERTURA_CENTRO_XSL;

			InputStream inputStream = null;

			StringBuffer xmlPdf = getXml(listadoFolderNumber);
			String xml = CaracteresRarosUtil.htmlEscape(xmlPdf.toString());
			StringReader lxmlReader = new StringReader(xml);
			// Inicializo transformer
			Transformer transformer = pdfTransformacionInit(xslFichero);
			// Ejecuto transformación
			ByteArrayOutputStream byteOut = pdfTransformacionExec(transformer,
					lxmlReader, org.apache.fop.apps.Driver.RENDER_PDF);

			byte[] bytes = byteOut.toByteArray();
			inputStream = new ByteArrayInputStream(bytes);

			byteOut.close();

			return inputStream;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Inicializa la transformacion a PDF.
	 * 
	 * xslFichero String Transformer
	 * 
	 * @param xslFichero
	 *            the xsl fichero
	 * @return the transformer
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private Transformer pdfTransformacionInit(String xslFichero)
			throws AB04BException {
		try {
			TransformerFactory tFactory = TransformerFactory.newInstance();
			// org.apache.fop.configuration.Configuration.put("baseDir", "c:/");
			return tFactory.newTransformer(new StreamSource(xslFichero));
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Ejecuta la transformación PDF.
	 * 
	 * transformer transformer strReader strReader renderer renderer
	 * ByteArrayOutputStream
	 * 
	 * @param transformer
	 *            the transformer
	 * @param strReader
	 *            the str reader
	 * @param renderer
	 *            the renderer
	 * @return the byte array output stream
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private ByteArrayOutputStream pdfTransformacionExec(Transformer transformer,
			StringReader strReader, int renderer) throws AB04BException {
		try {
			DOMResult domResultado = new DOMResult();

			transformer.transform(new StreamSource(strReader), domResultado);

			org.apache.fop.apps.Driver driver = new org.apache.fop.apps.Driver();

			driver.setRenderer(renderer);

			ByteArrayOutputStream byteOut = new ByteArrayOutputStream();

			driver.setOutputStream(byteOut);
			driver.render((org.w3c.dom.Document) domResultado.getNode());
			driver.reset();

			return byteOut;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtiene los datos y genera el XML.
	 * 
	 * listadoFolderNumber String[] String
	 * 
	 * @param listadoFolderNumber
	 *            the listado folder number
	 * @return the xml
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private StringBuffer getXml(String[] listadoFolderNumber)
			throws AB04BException {
		String dur = "";
		try {
			VfichaApertura fichaApertura = new VfichaApertura();

			StringBuffer xml = new StringBuffer();
			xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xml.append("<impresiones>");
			for (int i = 0; i < listadoFolderNumber.length; i++) {
				fichaApertura = obtenerfichaApertura(listadoFolderNumber[i]);
				xml.append("<imprimirApertura>");
				xml.append("<numExp>");
				xml.append(fichaApertura.getNumexp());
				xml.append("</numExp>");

				xml.append("<anio>");
				xml.append((fichaApertura.getAnio() != null)
						? fichaApertura.getAnio() : "");
				xml.append("</anio>");
				xml.append("<mes>");
				xml.append((fichaApertura.getMes() != null)
						? fichaApertura.getMes() : "");
				xml.append("</mes>");
				xml.append("<mesEu>");
				xml.append((fichaApertura.getMeseus() != null)
						? fichaApertura.getMeseus() : "");
				xml.append("</mesEu>");
				xml.append("<dia>");
				xml.append((fichaApertura.getDia() != null)
						? fichaApertura.getDia() : "");
				xml.append("</dia>");
				xml.append("<provinciaCast>");
				xml.append((fichaApertura.getProvinciacast() != null)
						? fichaApertura.getProvinciacast() : "");
				xml.append("</provinciaCast>");
				xml.append("<provinciaEusk>");
				xml.append((fichaApertura.getProvinciaeusk() != null)
						? fichaApertura.getProvinciaeusk() : "");
				xml.append("</provinciaEusk>");

				// datos de la empresa

				xml.append(obtenerDatosEmpresa(fichaApertura));

				// datos del centro de trabajo

				xml.append(obtenerDatosCentro(fichaApertura));

				// datos de produccion

				xml.append("<maquinariaHerramientas>");
				xml.append((fichaApertura.getMaquinariaherramientas() != null)
						? fichaApertura.getMaquinariaherramientas() : "");
				xml.append("</maquinariaHerramientas>");

				xml.append("<superficieConstruida>");
				xml.append((fichaApertura.getSuperficieconstruida() != null)
						? fichaApertura.getSuperficieconstruida() : "");
				xml.append("</superficieConstruida>");
				xml.append("<potenciaInstalada>");
				xml.append((fichaApertura.getPotenciainstalada() != null)
						? fichaApertura.getPotenciainstalada() : "");
				xml.append("</potenciaInstalada>");
				xml.append("<trabajoAnexoI>");
				xml.append((fichaApertura.getTrabajoanexoi() != null)
						? fichaApertura.getTrabajoanexoi() : "");
				xml.append("</trabajoAnexoI>");
				xml.append("<noTrabajoAnexoI>");
				xml.append((fichaApertura.getNotrabajoanexoi() != null)
						? fichaApertura.getNotrabajoanexoi() : "");
				xml.append("</noTrabajoAnexoI>");
				xml.append("<apartadoAnexoI>");
				xml.append((fichaApertura.getApartadoanexoi() != null)
						? fichaApertura.getApartadoanexoi() : "");
				xml.append("</apartadoAnexoI>");
				xml.append("<firma>");
				xml.append((fichaApertura.getFirma() != null)
						? fichaApertura.getFirma() : "");
				xml.append("</firma>");

				// datos de la obra de construccion
				xml.append("<tipoObra>");

				xml.append((fichaApertura.getTipoobra() != null)
						? fichaApertura.getTipoobra() : "");
				xml.append("</tipoObra>");
				xml.append("<regEmpresasAcreditadas>");
				xml.append((fichaApertura.getNumregistroempresa() != null)
						? fichaApertura.getNumregistroempresa() : "");
				xml.append("</regEmpresasAcreditadas>");
				xml.append("<dirExactaObra>");
				xml.append((fichaApertura.getDirexactaobra() != null)
						? fichaApertura.getDirexactaobra() : "");
				xml.append("</dirExactaObra>");

				xml.append(this.getListaPromotores(fichaApertura));
				xml.append(this.getListaProyectistas(fichaApertura));
				xml.append(
						this.getListaCoordinadoresElaboracion(fichaApertura));
				xml.append(this.getListaCoordinadoresEjecucion(fichaApertura));

				xml.append("<coordinadorElaboracion>");
				xml.append(
						this.obtenerNumCoordinadoresElaboracion(fichaApertura));
				xml.append("</coordinadorElaboracion>");
				xml.append("<coordinadorEjecucion>");
				xml.append(this.obtenerNumCoordinadorEjecucion(fichaApertura));
				xml.append("</coordinadorEjecucion>");
				xml.append("<fechaComienzoObra>");
				if (fichaApertura.getFechacomienzoobra() != null) {
					SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
					xml.append(
							sdf.format(fichaApertura.getFechacomienzoobra()));
				}

				xml.append("</fechaComienzoObra>");
				xml.append("<duracionPrevista>");
				dur = fichaApertura.getDuracionprevistacontratista();
				if (dur != null) {
					xml.append(dur.subSequence(0, (dur.length() - 1)));
					switch (dur.charAt(dur.length() - 1)) {
					case 'D':
						xml.append(" dias");
						break;
					case 'A':
						xml.append(" años");
						break;
					case 'M':
						xml.append(" meses");
						break;
					default:
						break;
					}
				}
				xml.append("</duracionPrevista>");
				xml.append("<duracionPrevistaContratista>");
				xml.append(
						(fichaApertura.getDuracionprevistacontratista() != null)
								? fichaApertura.getDuracionprevistacontratista()
								: "");
				xml.append("</duracionPrevistaContratista>");
				xml.append("<numeroContratista>");
				xml.append((fichaApertura.getNumerocontratista() != null)
						? fichaApertura.getNumerocontratista() : "");
				xml.append("</numeroContratista>");
				xml.append("<totalTrabajadoresObra>");
				xml.append((fichaApertura.getNummaxtrabajadoresobra() != null)
						? fichaApertura.getNummaxtrabajadoresobra() : "");
				xml.append("</totalTrabajadoresObra>");
				xml.append(getAnexoII(fichaApertura));

				xml.append("</imprimirApertura>");
			}
			xml.append("</impresiones>");
			return xml;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * /** Devuelve el objeto ficha apertura con los datos.
	 * 
	 * pkFicha String String
	 * 
	 * @param pkFicha
	 *            the pk ficha
	 * @return the vficha apertura
	 */
	private VfichaApertura obtenerfichaApertura(String pkFicha) {
		String numExp = "";
		String anio = "";
		int numero = 0;
		String territorio = "";
		VfichaApertura fichaApertura = new VfichaApertura();

		if (pkFicha.contains("~")) {
			StringTokenizer token = new StringTokenizer(pkFicha, "~");

			if (token.hasMoreTokens()) {
				territorio = (String) token.nextToken();
			}
			if (token.hasMoreTokens()) {
				anio = (String) token.nextToken();
			}
			if (token.hasMoreTokens()) {
				numero = Integer.parseInt((String) token.nextToken());
			}
			StringBuffer folderNumber = new StringBuffer();
			folderNumber.append(territorio).append("-");
			folderNumber.append(anio).append("-");
			folderNumber.append(numero);
			numExp = folderNumber.toString();
			fichaApertura.setNumexp(numExp);
		} else {
			numExp = pkFicha.replaceAll("/", "-");
			fichaApertura.setNumexp(numExp);
		}
		return this.vfichaAperturaService.find(fichaApertura);
	}

	/**
	 * /** Obtiene los datos del Centro de trabajo.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the string
	 */
	private String obtenerDatosCentro(VfichaApertura fichaApertura) {
		StringBuffer xml = new StringBuffer();
		xml.append("<nuevoCentro>");
		xml.append((fichaApertura.getNuevocentro() != null)
				? fichaApertura.getNuevocentro() : "");
		xml.append("</nuevoCentro>");
		xml.append("<reanudacionActividad>");
		xml.append((fichaApertura.getReanudacionactividad() != null)
				? fichaApertura.getReanudacionactividad() : "");
		xml.append("</reanudacionActividad>");
		xml.append("<cambioActividad>");
		xml.append((fichaApertura.getCambioactividad() != null)
				? fichaApertura.getCambioactividad() : "");
		xml.append("</cambioActividad>");
		xml.append("<traslado>");
		xml.append((fichaApertura.getTraslado() != null)
				? fichaApertura.getTraslado() : "");
		xml.append("</traslado>");
		xml.append("<cambiorasonsocial>");
		xml.append((fichaApertura.getCambiorazonsocial() != null)
				? fichaApertura.getCambiorazonsocial() : "");
		xml.append("</cambiorasonsocial>");
		xml.append("<nombreCentro>");
		xml.append((fichaApertura.getNombrecentro() != null)
				? fichaApertura.getNombrecentro() : "");
		xml.append("</nombreCentro>");
		xml.append("<municipioCentro>");
		xml.append((fichaApertura.getMunicipiocentro() != null)
				? fichaApertura.getMunicipiocentro() : "");
		xml.append("</municipioCentro>");
		xml.append("<provinciaCentro>");
		xml.append((fichaApertura.getProvinciacentro() != null)
				? fichaApertura.getProvinciacentro() : "");
		xml.append("</provinciaCentro>");
		xml.append("<direccionCentro>");
		xml.append((fichaApertura.getDireccioncentro() != null)
				? fichaApertura.getDireccioncentro() : "");
		xml.append("</direccionCentro>");
		xml.append("<actividadEconomicaCentro>");
		xml.append((fichaApertura.getActividadeconomicacentro() != null)
				? fichaApertura.getActividadeconomicacentro() : "");
		xml.append("</actividadEconomicaCentro>");
		xml.append("<faxCentro>");
		xml.append((fichaApertura.getFaxcentro() != null)
				? fichaApertura.getFaxcentro() : "");
		xml.append("</faxCentro>");
		xml.append("<emailCentro>");
		xml.append((fichaApertura.getEmailcentro() != null)
				? fichaApertura.getEmailcentro() : "");
		xml.append("</emailCentro>");
		xml.append("<telefonoCentro>");
		xml.append((fichaApertura.getTelefonocentro() != null)
				? fichaApertura.getTelefonocentro() : "");
		xml.append("</telefonoCentro>");
		xml.append("<cpCentro>");
		xml.append((fichaApertura.getCpcentro() != null)
				? fichaApertura.getCpcentro() : "");
		xml.append("</cpCentro>");
		xml.append("<diaInicioActividad>");
		xml.append((fichaApertura.getDiainicioactividad() != null)
				? fichaApertura.getDiainicioactividad() : "");
		xml.append("</diaInicioActividad>");
		xml.append("<mesInicioActividad>");
		xml.append((fichaApertura.getMesinicioactividad() != null)
				? fichaApertura.getMesinicioactividad() : "");
		xml.append("</mesInicioActividad>");
		xml.append("<anioInicioActividad>");
		xml.append((fichaApertura.getAnioinicioactividad() != null)
				? fichaApertura.getAnioinicioactividad() : "");
		xml.append("</anioInicioActividad>");
		xml.append("<nssProvCentro>");
		xml.append((fichaApertura.getNssprovcentro() != null)
				? fichaApertura.getNssprovcentro() : "");
		xml.append("</nssProvCentro>");
		xml.append("<nssNumCentro>");
		xml.append((fichaApertura.getNssnumcentro() != null)
				? fichaApertura.getNssnumcentro() : "");
		xml.append("</nssNumCentro>");
		xml.append("<nssDigCentro>");
		xml.append((fichaApertura.getNssdigcentro() != null)
				? fichaApertura.getNssdigcentro() : "");
		xml.append("</nssDigCentro>");
		xml.append("<trabajadoresHombre>");
		xml.append((fichaApertura.getTrabajadoreshombre() != null)
				? fichaApertura.getTrabajadoreshombre() : "");
		xml.append("</trabajadoresHombre>");
		xml.append("<trabajadoresMujer>");
		xml.append((fichaApertura.getTrabajadoresmujer() != null)
				? fichaApertura.getTrabajadoresmujer() : "");
		xml.append("</trabajadoresMujer>");
		xml.append("<totalTrabajadores>");
		xml.append((fichaApertura.getTotaltrabajadores() != null)
				? fichaApertura.getTotaltrabajadores() : "");
		xml.append("</totalTrabajadores>");
		xml.append("<claseCentro>");
		xml.append((fichaApertura.getClasecentro() != null)
				? fichaApertura.getClasecentro() : "");
		xml.append("</claseCentro>");
		xml.append("<descripcionObraCentro>");
		xml.append((fichaApertura.getDescripcionobracentro() != null)
				? fichaApertura.getDescripcionobracentro() : "");
		xml.append("</descripcionObraCentro>");
		xml.append("<acompanaPlanSeguridad>");
		xml.append((fichaApertura.getAcompanaplanseguridad() != null)
				? fichaApertura.getAcompanaplanseguridad() : "");
		xml.append("</acompanaPlanSeguridad>");
		xml.append("<noAcompanaPlanSeguridad>");
		xml.append((fichaApertura.getNoacompanaplanseguridad() != null)
				? fichaApertura.getNoacompanaplanseguridad() : "");
		xml.append("</noAcompanaPlanSeguridad>");
		xml.append("<adjuntaProyectoTecnico>");
		xml.append((fichaApertura.getAdjuntaproyectotecnico() != null)
				? fichaApertura.getAdjuntaproyectotecnico() : "");
		xml.append("</adjuntaProyectoTecnico>");
		xml.append("<noAdjuntaProyectoTecnico>");
		xml.append((fichaApertura.getNoadjuntaproyectotecnico() != null)
				? fichaApertura.getNoadjuntaproyectotecnico() : "");
		xml.append("</noAdjuntaProyectoTecnico>");
		xml.append("<modalidadPreventiva>");
		xml.append((fichaApertura.getModalidadorganizativadesc() != null)
				? fichaApertura.getModalidadorganizativadesc() : "");
		xml.append("</modalidadPreventiva>");
		return xml.toString();
	}

	/**
	 * /** Obtiene los datos de la empresa.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the string
	 */
	private String obtenerDatosEmpresa(VfichaApertura fichaApertura) {
		StringBuffer xml = new StringBuffer();
		xml.append("<numAvisoPrevio>");
		xml.append("");
		xml.append("</numAvisoPrevio>");
		xml.append("<empresaExistente>");
		xml.append((fichaApertura.getEmpresaexistente() != null)
				? fichaApertura.getEmpresaexistente() : "");
		xml.append("</empresaExistente>");
		xml.append("<empresaNoExistente>");
		xml.append((fichaApertura.getEmpresanoexistente() != null)
				? fichaApertura.getEmpresanoexistente() : "");
		xml.append("</empresaNoExistente>");
		xml.append("<numeroDocumento>");
		xml.append((fichaApertura.getNumerodocumento() != null)
				? fichaApertura.getNumerodocumento() : "");
		xml.append("</numeroDocumento>");
		xml.append("<razonSocial>");
		xml.append((fichaApertura.getRazonsocial() != null)
				? fichaApertura.getRazonsocial() : "");
		xml.append("</razonSocial>");
		xml.append("<direccion>");
		xml.append((fichaApertura.getDireccion() != null)
				? fichaApertura.getDireccion() : "");
		xml.append("</direccion>");
		xml.append("<municipioEmpresa>");
		xml.append((fichaApertura.getMunicipioempresa() != null)
				? fichaApertura.getMunicipioempresa() : "");
		xml.append("</municipioEmpresa>");
		xml.append("<territorioEmpresa>");
		xml.append((fichaApertura.getTerritorioempresa() != null)
				? fichaApertura.getTerritorioempresa() : "");
		xml.append("</territorioEmpresa>");
		xml.append("<cp>");
		xml.append(
				(fichaApertura.getCp() != null) ? fichaApertura.getCp() : "");
		xml.append("</cp>");
		xml.append("<telefonoEmpresa>");
		xml.append((fichaApertura.getTelefonoempresa() != null)
				? fichaApertura.getTelefonoempresa() : "");
		xml.append("</telefonoEmpresa>");
		xml.append("<actividadEconomica>");
		xml.append((fichaApertura.getActividadeconomica() != null)
				? fichaApertura.getActividadeconomica() : "");
		xml.append("</actividadEconomica>");
		xml.append("<entidadGestoraColaboradora>");
		xml.append((fichaApertura.getEntidadgestoracolaboradora() != null)
				? fichaApertura.getEntidadgestoracolaboradora() : "");
		xml.append("</entidadGestoraColaboradora>");

		return xml.toString();
	}

	/**
	 * /** Obtiene el numero de coordinadores de ejecucion.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the long
	 */
	private long obtenerNumCoordinadorEjecucion(VfichaApertura fichaApertura) {
		StringTokenizer token = new StringTokenizer(fichaApertura.getNumexp(),
				"-");

		String anio = "";
		int numero = 0;
		String territorio = "";

		if (token.hasMoreTokens()) {
			territorio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			anio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			numero = Integer.parseInt((String) token.nextToken());
		}

		CoordinadorObra coordinador = new CoordinadorObra();
		coordinador.setCodobra084(fichaApertura.getCodobra());
		coordinador.setAnoexp084(anio);
		coordinador.setNumexp084(numero);
		coordinador.setTerexp084(territorio);
		coordinador.setTipcrd084("E");
		return this.coordinadorObraService
				.contarCoordeinadoresObra(coordinador);
	}

	/**
	 * /** Obtiene el numero de coordinadores de proyecto.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the long
	 */
	private long obtenerNumCoordinadoresElaboracion(
			VfichaApertura fichaApertura) {
		StringTokenizer token = new StringTokenizer(fichaApertura.getNumexp(),
				"-");

		String anio = "";
		int numero = 0;
		String territorio = "";

		if (token.hasMoreTokens()) {
			territorio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			anio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			numero = Integer.parseInt((String) token.nextToken());
		}

		CoordinadorObra coordinador = new CoordinadorObra();
		coordinador.setCodobra084(fichaApertura.getCodobra());
		coordinador.setAnoexp084(anio);
		coordinador.setNumexp084(numero);
		coordinador.setTerexp084(territorio);
		coordinador.setTipcrd084("P");
		return this.coordinadorObraService
				.contarCoordeinadoresProyecto(coordinador);
	}

	/**
	 * /** Obtiene los datos del Anexo II.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the anexo II
	 */
	public static String getAnexoII(VfichaApertura fichaApertura) {
		StringBuffer xml = new StringBuffer("");
		xml.append("<realizaTrabajos>");
		xml.append((fichaApertura.getRealizatrabajos() != null)
				? fichaApertura.getRealizatrabajos() : "");
		xml.append("</realizaTrabajos>");
		xml.append("<noRealizaTrabajos>");
		xml.append((fichaApertura.getNorealizatrabajos() != null)
				? fichaApertura.getNorealizatrabajos() : "");
		xml.append("</noRealizaTrabajos>");

		xml.append("<tipoAnexo2>");
		xml.append((fichaApertura.getTipoanexo2() != null)
				? fichaApertura.getTipoanexo2() : "");
		xml.append("</tipoAnexo2>");
		xml.append("<descripcionAnexo2>");
		xml.append((fichaApertura.getDescripcionanexo2() != null)
				? fichaApertura.getDescripcionanexo2() : "");
		xml.append("</descripcionAnexo2>");
		return xml.toString();
	}

	/**
	 * Obtiene la lista de Coordinadores en Ejecucion.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the lista coordinadores ejecucion
	 */
	public String getListaCoordinadoresEjecucion(VfichaApertura fichaApertura) {
		StringTokenizer token = new StringTokenizer(fichaApertura.getNumexp(),
				"-");

		String anio = "";
		int numero = 0;
		String territorio = "";

		if (token.hasMoreTokens()) {
			territorio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			anio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			numero = Integer.parseInt((String) token.nextToken());
		}

		StringBuffer xml = new StringBuffer("");
		CoordinadorObra coordinador = new CoordinadorObra();
		coordinador.setCodobra084(fichaApertura.getCodobra());
		coordinador.setAnoexp084(anio);
		coordinador.setNumexp084(numero);
		coordinador.setTerexp084(territorio);
		coordinador.setTipcrd084("E");
		List listaCoordinadoresEjecucion = this.coordinadorObraService
				.findAll(coordinador, null);

		if (listaCoordinadoresEjecucion != null) {
			CoordinadorObra coor = null;
			for (int i = 0; i < listaCoordinadoresEjecucion.size(); i++) {
				coor = (CoordinadorObra) listaCoordinadoresEjecucion.get(i);

				xml.append("<coordinadoresEjecucion>");
				xml.append("<nombreEjecucion>");
				xml.append((coor != null && coor.getNomcrd084() != null)
						? coor.getNomcrd084() : "");
				xml.append("</nombreEjecucion>");
				xml.append("<dniEjecucion>");
				xml.append((coor != null && coor.getNumdoc084() != null)
						? coor.getNumdoc084() : "");
				xml.append("</dniEjecucion>");
				xml.append("<direccionEjecucion>");
				xml.append((coor != null && coor.getDircrd084() != null)
						? coor.getDircrd084() : "");
				xml.append((coor != null && coor.getCpocrd084() != null)
						? " " + coor.getCpocrd084() : "");
				xml.append((coor != null && coor.getDescMunicipio() != null)
						? " (" + coor.getDescMunicipio() + ")" : "");
				xml.append((coor != null && coor.getTlfcrd084() != null)
						? " Tlf.: " + coor.getTlfcrd084() : "");
				xml.append("</direccionEjecucion>");
				xml.append("</coordinadoresEjecucion>");
			}
		}
		return xml.toString();
	}

	/**
	 * Obtiene la lista de Coordinadores de Elaboracion.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the lista coordinadores elaboracion
	 */
	public String getListaCoordinadoresElaboracion(
			VfichaApertura fichaApertura) {
		StringTokenizer token = new StringTokenizer(fichaApertura.getNumexp(),
				"-");

		String anio = "";
		int numero = 0;
		String territorio = "";

		if (token.hasMoreTokens()) {
			territorio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			anio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			numero = Integer.parseInt((String) token.nextToken());
		}
		StringBuffer xml = new StringBuffer("");
		CoordinadorObra coordinador = new CoordinadorObra();
		coordinador.setCodobra084(fichaApertura.getCodobra());
		coordinador.setAnoexp084(anio);
		coordinador.setNumexp084(numero);
		coordinador.setTerexp084(territorio);
		coordinador.setTipcrd084("P");
		List listaCoordinadoresEjecucion = this.coordinadorObraService
				.findAll(coordinador, null);

		if (listaCoordinadoresEjecucion != null) {
			CoordinadorObra coor = null;
			for (int i = 0; i < listaCoordinadoresEjecucion.size(); i++) {
				coor = (CoordinadorObra) listaCoordinadoresEjecucion.get(i);

				xml.append("<coordinadoresElaboracion>");
				xml.append("<nombreElaboracion>");
				xml.append((coor != null && coor.getNomcrd084() != null)
						? coor.getNomcrd084() : "");
				xml.append("</nombreElaboracion>");
				xml.append("<dniElaboracion>");
				xml.append((coor != null && coor.getNumdoc084() != null)
						? coor.getNumdoc084() : "");
				xml.append("</dniElaboracion>");
				xml.append("<direccionElaboracion>");
				xml.append((coor != null && coor.getDircrd084() != null)
						? coor.getDircrd084() : "");
				xml.append((coor != null && coor.getCpocrd084() != null)
						? " " + coor.getCpocrd084() : "");
				xml.append((coor != null && coor.getDescMunicipio() != null)
						? " (" + coor.getDescMunicipio() + ")" : "");
				xml.append("</direccionElaboracion>");
				xml.append("</coordinadoresElaboracion>");
			}
		}
		return xml.toString();
	}

	/**
	 * Obtiene la lista de Proyectistas.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the lista proyectistas
	 */
	public String getListaProyectistas(VfichaApertura fichaApertura) {
		StringTokenizer token = new StringTokenizer(fichaApertura.getNumexp(),
				"-");

		String anio = "";
		int numero = 0;
		String territorio = "";

		if (token.hasMoreTokens()) {
			territorio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			anio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			numero = Integer.parseInt((String) token.nextToken());
		}

		StringBuffer xml = new StringBuffer("");
		Proyectista proyectista = new Proyectista();
		proyectista.setCodobra083(fichaApertura.getCodobra());
		proyectista.setAnoexp083(anio);
		proyectista.setNumexp083(numero);
		proyectista.setTerexp083(territorio);
		List listaProyectistas = this.proyectistaService.findAll(proyectista,
				null);

		if (listaProyectistas != null) {
			Proyectista proy = null;
			for (int i = 0; i < listaProyectistas.size(); i++) {
				proy = (Proyectista) listaProyectistas.get(i);

				xml.append("<proyectistas>");
				xml.append("<nombreProyectista>");
				xml.append((proy != null && proy.getNompry083() != null)
						? proy.getNompry083() : "");
				xml.append("</nombreProyectista>");
				xml.append("<dniProyectista>");
				xml.append((proy != null && proy.getNumdoc083() != null)
						? proy.getNumdoc083() : "");
				xml.append("</dniProyectista>");
				xml.append("<direccionProyectista>");
				xml.append((proy != null && proy.getDirpry083() != null)
						? proy.getDirpry083() : "");
				xml.append((proy != null && proy.getCpopry083() != null)
						? " " + proy.getCpopry083() : "");
				xml.append((proy != null && proy.getMunicipio() != null)
						? " (" + proy.getMunicipio() + ")" : "");
				xml.append("</direccionProyectista>");
				xml.append("</proyectistas>");
			}
		}

		return xml.toString();
	}

	/**
	 * Obtiene la lista de Promotores.
	 * 
	 * fichaApertura VfichaApertura String
	 * 
	 * @param fichaApertura
	 *            the ficha apertura
	 * @return the lista promotores
	 */
	public String getListaPromotores(VfichaApertura fichaApertura) {
		StringTokenizer token = new StringTokenizer(fichaApertura.getNumexp(),
				"-");

		String anio = "";
		int numero = 0;
		String territorio = "";

		if (token.hasMoreTokens()) {
			territorio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			anio = (String) token.nextToken();
		}
		if (token.hasMoreTokens()) {
			numero = Integer.parseInt((String) token.nextToken());
		}
		StringBuffer xml = new StringBuffer("");

		Promotor promotor = new Promotor();
		promotor.setCodobra085(fichaApertura.getCodobra());
		promotor.setAnoexp085(anio);
		promotor.setNumexp085(numero);
		promotor.setTerexp085(territorio);
		List listaPromotores = this.promotorService.findAll(promotor, null);

		if (listaPromotores != null) {
			Promotor prom = null;
			for (int i = 0; i < listaPromotores.size(); i++) {
				prom = (Promotor) listaPromotores.get(i);
				if (prom != null && "P".equals(prom.getTipoprm085())) {
					// unicamente se imprime el promotor principal de las
					// aperturas nuevas, las viejas directamente no tenian datos
					// de obra
					xml.append("<promotores>");
					xml.append("<nombrePromotor>");
					xml.append((prom != null && prom.getNomprm085() != null)
							? prom.getNomprm085() : "");
					xml.append("</nombrePromotor>");
					xml.append("<dniPromotor>");
					xml.append((prom != null && prom.getNumdoc085() != null)
							? prom.getNumdoc085() : "");
					xml.append("</dniPromotor>");
					xml.append("<direccionPromotor>");
					xml.append((prom != null && prom.getDirprm085() != null)
							? prom.getDirprm085() + " " : "");
					xml.append((prom != null && prom.getCpoprm085() != null)
							? prom.getCpoprm085() : "");
					xml.append((prom != null && prom.getMunicipio() != null)
							? " (" + prom.getMunicipio().getDescripcion() + ")"
							: "");
					xml.append("</direccionPromotor>");
					xml.append("</promotores>");
				}
			}
		}

		return xml.toString();
	}

}
